#pragma once

#include "EMF/TreeControl/TreeOptionsCtrl.h" //==> dlarge TreeControl
#include "Preferences.h"
#include "OtherFunctions.h"

class CPPgTweaks2 : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgTweaks2)

public:
	CPPgTweaks2();
	virtual ~CPPgTweaks2();


	enum { IDD = IDD_PPG_TWEAKS2}; 

protected:

	CTreeOptionsCtrl m_ctrlTreeOptions; //==> dlarge TreeControl
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiXPMenu;

//==> dlarge Smart Category Control 
	int m_iDlMode;
	bool m_bShowCatNames;
	bool m_bSelectCat;
	bool m_bUseActiveCat;
	bool m_bAutoSetResOrder;
	bool m_bSmallFileDLPush;
	int m_iResumeFileInNewCat;
	bool m_bUseAutoCat;
//<== dlarge Smart Category Control 

	bool m_bSUQWT; //==> dlarge SUQWT 

//==> dlarge Drop
	int iMaxRemoveQRS;
	int m_iDropSources;
	bool m_iDropSourcesNNS;
	int m_iDropSourcesTimerNNS;
	bool m_iDropSourcesFQ;
	int m_iDropSourcesTimerFQ;
	bool m_iDropSourcesHQR;
	int m_iDropSourcesTimerHQR;
//<== dlarge Drop

//==> dlarge QuickStart (Xanatos)
	bool	m_bQuickStart;
	int		m_iQuickStartTime;
	int		m_iQuickMaxConperFive;
	int		m_iQuickMaxHalfOpen;
	int		m_iQuickMaxConnections;

	HTREEITEM m_htiQuickStart;
	HTREEITEM m_htiQuickStartEnable;
	HTREEITEM m_htiQuickStartTime;
	HTREEITEM m_htiQuickMaxConperFive;
	HTREEITEM m_htiQuickMaxHalfOpen;
	HTREEITEM m_htiQuickMaxConnections;
//<== dlarge QuickStart (Xanatos)

//==> dlarge high process priority 
	HTREEITEM m_htiHighProcess;
	HTREEITEM m_htiHighProcessMode_low;
	HTREEITEM m_htiHighProcessMode_lower;
	HTREEITEM m_htiHighProcessMode_normal;
	HTREEITEM m_htiHighProcessMode_higher;
	HTREEITEM m_htiHighProcessMode_high;
	int m_iHighProcessMode;
//<== dlarge high process priority 

//==> dlarge Drop
	HTREEITEM m_htiDropSources;
	HTREEITEM m_htiDropSourcesNNS;
	HTREEITEM m_htiDropSourcesTimerNNS;
	HTREEITEM m_htiDropSourcesFQ;
	HTREEITEM m_htiDropSourcesTimerFQ;
	HTREEITEM m_htiDropSourcesHQR;
	HTREEITEM m_htiDropSourcesTimerHQR;
	HTREEITEM m_htiHqrBox;
//<== dlarge Drop

//==> dlarge auto priority
	HTREEITEM hGrpAPrio;
		HTREEITEM hUseAPrio;
		HTREEITEM hAPrioHigh;
		HTREEITEM hAPrioNorm;
		HTREEITEM hAPrioKeepLow;
		bool bUseAPrio;
		bool bAPrioKeepLow;
		int  iAPrioHigh;
		int  iAPrioNorm;
//<== dlarge auto priority

//==> dlarge SUC/USS
	bool m_bSUCLog;
	int m_iSUCHigh;
	int m_iSUCLow;
	int m_iSUCPitch;
	int m_iSUCDrift;
	bool m_bUSSLimit; 
	bool m_bUSSLog;
	bool m_bUSSUDP; 
	int m_sPingDataSize; 
	int m_iUSSPingLimit; 
        int m_iUSSPingTolerance;
        int m_iUSSGoingUpDivider;
        int m_iUSSGoingDownDivider;
        int m_iUSSNumberOfPings;
	int m_iUSSTTL;
	int m_iMinUpload;
	int m_iDynUpMode;
	int m_iMaxConnectionsSwitchBorder;

	HTREEITEM m_htiUM;
	HTREEITEM m_htiDYNUP;
	HTREEITEM m_htiDynUpOFF;
	HTREEITEM m_htiDynUpSUC;
	HTREEITEM m_htiDynUpUSS;
	HTREEITEM m_htiDynUpAutoSwitching;
	HTREEITEM m_htiMaxConnectionsSwitchBorder;
	HTREEITEM m_htiSUCLog;
	HTREEITEM m_htiSUCHigh;
	HTREEITEM m_htiSUCLow;
	HTREEITEM m_htiSUCPitch;
	HTREEITEM m_htiSUCDrift;
	HTREEITEM m_htiUSSLog;
	HTREEITEM m_htiUSSUDP; 
	HTREEITEM m_htiUSSLimit; 
	HTREEITEM m_htiUSSPingLimit; 
        HTREEITEM m_htiUSSPingTolerance;
        HTREEITEM m_htiUSSGoingUpDivider;
        HTREEITEM m_htiUSSGoingDownDivider;
        HTREEITEM m_htiUSSNumberOfPings;
	HTREEITEM m_htiUSSTTL;
	HTREEITEM m_htiMinUpload;
	HTREEITEM m_htiPingDataSize;   
	HTREEITEM m_htiUpSecu;
//<== dlarge SUC/USS

//==> dlarge CreditSystem
	int m_iCreditSystem;
	HTREEITEM m_htiCreditSystem;
	HTREEITEM m_htiOfficialCredit;
	HTREEITEM m_htiLovelaceCredit;
	HTREEITEM m_htiPawcioCredit;
	HTREEITEM m_htiESCredit;
	HTREEITEM m_htiSivkaCredit;
	HTREEITEM m_htiSwatCredit;
	HTREEITEM m_htiXtremeCredit;
	HTREEITEM m_htiZzulCredit;
//<== dlarge CreditSystem

//==> dlarge Menu XP
	HTREEITEM m_htiXPMenuStyle;
	HTREEITEM m_htiXPMenuStyleOffice;
	HTREEITEM m_htiXPMenuStyleStartMenu;
	HTREEITEM m_htiXPMenuStyleXP;
	HTREEITEM m_htiShowXPSideBar;
	HTREEITEM m_htiShowXPBitmap;
	HTREEITEM m_htiGrayMenuIcon;
	bool	m_bShowXPSideBar;
	bool	m_bShowXPBitmap;
	int	m_iXPMenuStyle;
	bool	m_bGrayMenuIcon;
//<== dlarge Menu XP

//==> dlarge CPU/MEM 
	bool m_bSysInfo;
	bool m_bSysInfoGlobal;
	HTREEITEM m_htiSysInfoGroup;
	HTREEITEM m_htiSysInfo;
	HTREEITEM m_htiSysInfoGlobal;
//<== dlarge CPU/MEM 

//==> dlarge Display Settings
	bool m_bQueueProgressBar; //==> dlarge Client queue progress bar 
	HTREEITEM m_htiQueueProgressBar; //==> dlarge Client queue progress bar 

	bool m_bShowClientPercentage; //==> dlarge Client Percentage (Xman)
	HTREEITEM m_htiShowClientPercentage; //==> dlarge Client Percentage (Xman)

	bool m_bEnableChunkDots;
	HTREEITEM m_htiEnableChunkDots;

	bool m_bShowSessionDownload;
	HTREEITEM m_htiSessionDownload;

	bool m_bSideBanner;
	HTREEITEM m_htiSideBanner;

	bool	m_bUseRelativeChunkDisplay; 
	HTREEITEM m_htiUseRelativeChunkDisplay; 
//<== dlarge Display Settings

//==> dlarge minimule 
	bool m_bShowMM;
	bool m_bMMLives;
	int m_iMMUpdateTime;
	int m_iMMTrans;
	bool m_bMMBanner;
	bool m_bMMCompl;
	bool m_bMMOpen;

	HTREEITEM m_htiMMGroup;
	HTREEITEM m_htiShowMM;
	HTREEITEM m_htiMMLives;
	HTREEITEM m_htiMMUpdateTime;
	HTREEITEM m_htiMMTrans;
	HTREEITEM m_htiMMBanner;
	HTREEITEM m_htiMMCompl;
	HTREEITEM m_htiMMOpen;
//<== dlarge minimule 

//==> dlarge Smart Category Control 
	HTREEITEM m_htiSCC;
	HTREEITEM m_htiDlMode;
	HTREEITEM m_htiDlNone;
	HTREEITEM m_htiDlAlph;
	HTREEITEM m_htiDlLP;
	HTREEITEM m_htiShowCatNames;
	HTREEITEM m_htiSelectCat;
	HTREEITEM m_htiUseActiveCat;
	HTREEITEM m_htiAutoSetResOrder;
	HTREEITEM m_htiSmallFileDLPush;
	HTREEITEM m_htiResumeFileInNewCat;
	HTREEITEM m_htiUseAutoCat;
//<== dlarge Smart Category Control 

//==> dlarge Misc Settings
	HTREEITEM m_htiMisc;
	HTREEITEM m_htiSUQWT; //==> dlarge SUQWT 

	bool m_bStaticIcon;
	HTREEITEM m_htiStaticIcon; 

	bool m_bTrayComplete; 
	HTREEITEM m_htiTrayComplete; 

	bool m_bAutoSharedUpdater;
	HTREEITEM m_htiAutoSharedUpdater; 

	bool	m_bTrayPasswordProtection;
	CString	m_sTrayPassword;

	HTREEITEM m_htiTrayPasswordProtection;
//<<== dlarge Misc Settings

	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

DECLARE_MESSAGE_MAP()
public:
	void Localize(void);	
	void LoadSettings(void);
	virtual BOOL OnApply();
	virtual BOOL OnInitDialog();
	virtual BOOL OnKillActive();

};
